dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 5, 240, 260, "assets/images/table/island_6", "assets/images/food/item_mark2", "R" );
LManager:AddNewTable( 2, 5, 220, 420, "assets/images/table/island_6", "assets/images/food/item_mark3", "B" );


useFloAsServer = 0;
useWineTable = 1;
numMoodBoosts = 2;
numServers = 1;
maxCoupleHappiness = 400;

-- Group 1

guest = LManager.GenGuest(female04);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = table1;
guest.percentRequestDrink = 30;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = male02;
guest.percentRequestMusic = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = female04;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(1, 5, 3000);


-- Group 2

guest = LManager.GenGuest(female03);
guest.matchType = table2;
guest.percentRequestMusic = 30;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = male03;
guest.percentRequestDrink = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = female04;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(6, 10, 28000);


-- Group 3

guest = LManager.GenGuest(male01);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = female03;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(11, 12, 40000);

-- Group 4

guest = LManager.GenGuest(female03);
guest.matchType = table1;
guest.percentRequestMusic = 30;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = table1;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(13, 15, 60000);


-- Group 5

guest = LManager.GenGuest(aunt);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = female03;
guest.percentRequestDrink = 30;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(16, 17, 90000);


-- Group 6

guest = LManager.GenGuest(female01);
guest.matchType = female03;
guest.percentRequestMusic = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = aunt;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.likes={female04};
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(18, 21, 130000);



LManager:AdjustGuestTolerance(130);

LManager:SetLevelSetting ("cakeTipDelay", 95000); 
LManager:SetLevelSetting ("cakeTipChance", 100);

LManager:AddQuinnEvent( "fx/fx_bees.lua", 600, 300, 120000 );

LManager:SetLevelSetting ("dogDelay", 65000); 
LManager:SetLevelSetting ("dogChance", 100);

LManager:AddReseatingRequestForGuest(170000, male04);
LManager:AddReseatingRequestForGuest(140000, aunt);

-- Set up the Level Settings
LManager:SetLevelNumber(4,8);
LManager:SetLevelScores(9000, 12500);
LManager:SetLevelTime(300000);

LManager:SetLevelSetting ("blaster", 1);

LManager:SetMusic("assets/audio/music/Big Band 4.ogg","assets/audio/music/Dance Dance 1.ogg","assets/audio/music/Disco Dance 1.ogg");
LManager:SetBackgroundImage("assets/images/bg_island");
LManager:SetChairImage("assets/images/table/chair04");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );